#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2014, Peter Pisljar'
__docformat__ = 'restructuredtext en'

from PyQt4.Qt import QWidget, QVBoxLayout, QLabel, QLineEdit

from calibre.utils.config import JSONConfig

import shutil
import fileinput

# This is where all preferences for this plugin will be stored
# Remember that this name (i.e. plugins/interface_demo) is also
# in a global namespace, so make it as unique as possible.
# You should always prefix your config file name with plugins/,
# so as to ensure you dont accidentally clobber a calibre config file
prefs = JSONConfig('plugins/solr_fulltext_search')

# Set defaults
prefs.defaults['pathToLibrary'] = '$HOME/Calibre Library'
prefs.defaults['pathToJava'] = ''
prefs.defaults['pathToSolr'] = '/usr/solr'
prefs.defaults['lastUpdate'] = '1970-1-1'

class ConfigWidget(QWidget):

    def __init__(self):
        QWidget.__init__(self)
        self.l = QVBoxLayout()
        self.setLayout(self.l)
                
        self.labelText = QLabel('Set the paths to the different directories.\nDo not use "/" at the end of the path.\nDefaults are:\nPath to Calibre Library directory: $HOME/Calibre Library\nPath to Calibre Cofig directory: $HOME/.config/calibre\nPath to solr directory: /usr/bin')
        
        
        self.l.addWidget(self.labelText)

        self.labelLibrary = QLabel('Path to Calibre Library directory:')
        self.l.addWidget(self.labelLibrary)

        self.pathToLibrarySetting = QLineEdit(self)
        self.pathToLibrarySetting.setText(prefs['pathToLibrary'])
        self.l.addWidget(self.pathToLibrarySetting)
        self.labelLibrary.setBuddy(self.pathToLibrarySetting)
        
        self.labelCofig = QLabel('Path to Java7 home folder:')
        self.l.addWidget(self.labelCofig)        
        
        self.pathToCofigSetting = QLineEdit(self)
        self.pathToCofigSetting.setText(prefs['pathToJava'])
        self.l.addWidget(self.pathToCofigSetting)
        self.labelCofig.setBuddy(self.pathToCofigSetting)
		
		self.labelSolr = QLabel('Path to Solr folder:')
        self.l.addWidget(self.labelSolr)        
        
        self.pathToSolrSetting = QLineEdit(self)
        self.pathToSolrSetting.setText(prefs['pathToSolr'])
        self.l.addWidget(self.pathToSolrSetting)
        self.labelSolr.setBuddy(self.pathToSolrSetting)
        
       

    def save_settings(self):
		libpath = unicode(self.pathToLibrarySetting.text())
		confpath = unicode(self.pathToCofigSetting.text())
		solrpath = unicode(self.pathToSolrSetting.text())
		
		if libpath != prefs['pathToLibrary'] or confpath != prefs['pathToJava'] or solrpath != prefs['pathToSolr']:
			#overwrite the config files with new ones with updated values
			#   it would be nice if we could just update the setting without overwriting full file
			infile = open(solrpath + '/etc/Jetty.xml.src')
			outfile = open(solrpath + '/etc/Jetty.xml', 'w')
			
			#lets update the values now
			for line in infile:
				outfile.write(line.replace('###calibrelibdir###', libpath))
				
			infile.close()
			outfile.close()
			
			infile = open(solrpath + '/solr/collection1/core.properties.src')
			outfile = open(solrpath + '/solr/collection1/core.properties', 'w')
				
			for line in infile:
				outfile.write(line.replace('###calibrelibdir###', libpath))
				
			infile.close()
			outfile.close()
		
		prefs['pathToLibrary'] = libpath
        prefs['pathToJava'] = confpath
        prefs['pathToSolr'] = solrpath

